/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
    All rights reserved.

    $Id: pgpBERPriv.h,v 1.15 2000/01/08 00:28:33 dallen Exp $
____________________________________________________________________________*/

/*
 * For extremely detailed explanation of all the BER types and
 * encoding, see X.208 (Specification of Abstract Syntax Notation One (ASN.1))
 * and X.209 (Specification of Basic Encoding Rules for Abstract Syntax
 * Notation One (ASN.1)).
 *
 * These two sources will tell you everything you would ever need (and want)
 * to know about BER and ASN.1.
 */

#ifndef Included_pgpBERPriv_h  /* [ */
#define Included_pgpBERPriv_h

#include "pgpBER.h"
#include "pgpPubTypes.h"
#include "pgpSockets.h"

#define	CKERR			if( IsPGPError( err ) ) { goto error; }
#define CKNULL(val)		if( IsNull( val ) ) \
						{ \
							err = kPGPError_OutOfMemory;\
							goto error;\
						}

/* Constants */

enum PGPberClass_
{
    kPGPberClass_Universal          = 0x00,	/* 0000 0000 */
    kPGPberClass_Application        = 0x40,	/* 0100 0000 */
    kPGPberClass_ContextSpecific    = 0x80,	/* 1000 0000 */
    kPGPberClass_Private            = 0xC0	/* 1100 0000 */
};
PGPENUM_TYPEDEF (PGPberClass_, PGPberClass);

enum PGPberMask_
{
    kPGPberMask_Primitive           = 0x00,	/* 0000 0000 */
    kPGPberMask_Constructed         = 0x20,	/* 0010 0000 */

    kPGPberMask_BigTag              = 0x1F,	/* 0001 1111 */
    kPGPberMask_MoreTag             = 0x80,	/* 1000 0000 */

	kPGPberMask_BigLength			= 0x80,	/* 1000 0000 */
	kPGPberMask_BigInt				= 0x80,	/* 1000 0000 */

	kPGPberMask_IndefLength			= 0x80	/* 1000 0000 */
};
PGPENUM_TYPEDEF (PGPberMask_, PGPberMask);

/* Data structures */

typedef struct PGPberElement
{
    PGPByte				*encoding;
    PGPSize				length;

    PGPUInt32			nextInsertIndex;
	PGPUInt32			nextReadIndex;

    PGPUInt32			tag;

    union
    {
        struct PGPberSequence  *nextSeq;
        struct PGPberSet       *nextSet;
    } next;
    union
    {
        struct PGPberSequence  *prevSeq;
        struct PGPberSet       *prevSet;
    } prev;

    PGPMemoryMgrRef		memMgr;
} PGPberElement;

typedef struct PGPberSequence
{
    struct PGPberElement   *nextBER;
    struct PGPberElement   *prevBER;

} PGPberSequence;

typedef PGPberSequence PGPberSet;

/* Functions */

	PGPError
pgpNewBERElement(
	PGPMemoryMgrRef		memMgr,
	PGPberElementRef *	ber );

	PGPError
pgpBERReadInt(
	PGPByte *			s,
	PGPSize				length,
	PGPInt32 *			outInt );

	PGPError
pgpBERGetTagEncoding(
	PGPUInt32			tag,
	PGPByte *			s, 
	PGPSize *			length);

	PGPError
pgpBERStrAppend(
	PGPberElementRef	ber,
	PGPByte *			src, 
	PGPUInt32			tag, 
	PGPSize 			srcLength );

	PGPError
pgpSeekLastBERElement(
	PGPberElementRef 	ber, 
	PGPberElementRef *	lastBER );

	PGPError
pgpBERGetLengthEncoding(
	PGPSize 			length,
	PGPByte *			s,
	PGPSize *			lengthOfLength );

	PGPError
pgpBERBeginSequence(
	PGPberElementRef	ber,
	PGPUInt32			tag );

	PGPError
pgpBEREndSequence(
	PGPberElementRef	ber );

	PGPError
pgpBERBeginSet(
	PGPberElementRef	ber,
	PGPUInt32			tag );

	PGPError
pgpBEREndSet(
	PGPberElementRef	ber );

	PGPError
pgpBERInsertInt(
	PGPberElementRef	ber, 
	PGPInt32			value, 
	PGPUInt32			tag );

	PGPError
pgpBERInsertString(
	PGPberElementRef	ber,
	char *				string,
	PGPUInt32			tag );

	PGPError
pgpBERInsertOctetstring(
	PGPberElementRef	ber,
	PGPByte *			string,
	PGPSize				length,
	PGPUInt32			tag );

	PGPError
pgpBERInsertNULL(
	PGPberElementRef	ber,
	PGPUInt32			tag );

	PGPInt32
pgpReceiveLen(
	PGPSocketRef		sock,
	void *				buffer,
	PGPUInt32			bufferSize );

	PGPError
pgpBERReadTag(
	PGPByte	*			s,
	PGPberType *		tag,
	PGPSize *			tagLength);

	PGPError
pgpBERFormatSpecifierToTag(
	PGPberFormatSpecifier	fmt,
	PGPberType *			berType );

	PGPError
pgpBERReadUInt(
	PGPByte *			s,
	PGPSize				length,
	PGPUInt32 *			outInt );

	PGPError
pgpBERReadLength(
	PGPByte	*			s,
	PGPSize *			length ,
	PGPSize *			lengthOfLength );

	PGPError
pgpBERReadString(
	PGPByte *			s,
	PGPSize				length,
	PGPByte *			outString );

#endif /* ] Included_pgpBERPriv_h */


/*__Editor_settings____

    Local Variables:
    tab-width: 4
    End:
    vi: ts=4 sw=4
    vim: si
_____________________*/
